// 03. Write a c program for sorting using quickey sort method.

#include<stdio.h>
#define N 10

void exchange(int a, int b, int nums[N]) {
    nums[a] = nums[a] ^ nums[b];
    nums[b] = nums[a] ^ nums[b];
    nums[a] = nums[a] ^ nums[b];
}

/*  here, always key < min, key < max
    min: index of minimum value in nums[] list    start from key+1
    max: index of maximum value in nums[] list    start from N - 1    */
int quick_sort(int nums[N]) {
    int key = 0, min, max;
    while(key < N - 1) {
        // this for loop codisiton >= and <= there = for avoiding equal value

        // find min index of value that grater then key index value
        for(min = key + 1; nums[key] >= nums[min] && min < N-1; min++);

        // find index of max value that less then key index value
        for(max = N - 1; nums[key] <= nums[max] && max > 1+key; max--);

        // key index value is allready sorted
        if (min == max && key + 1 == min && nums[key] < nums[min])
            key++;
        // min and max both point on last index
        else if(min == max && min == N - 1)
            return 0;
        else if(min == max && key < min && nums[key] > nums[min])
            exchange(key, min, nums);
        else if(min < max) 
            exchange(min, max, nums);
        else if(nums[key] != nums[max])
            exchange(key, max, nums); 
        else
            key++;
    }
}

int main() { 
    int i, numbers[N] = {52, 33, 84, 22, 75, 68, 104, 46, 109, 97};

    quick_sort(numbers);

    printf("Sorted numbers: \n");
    for(i=0; i < N; i++)
        printf("%6d  ", numbers[i]);
    
    return 0;
}

/*  output:
        Sorted numbers:
        22      33      46      52      68      75      84      97     104     109
        */